# 网站常见问题

## 502 Bad Gateway 是怎么回事？
出现 `502 Bad Gateway` 通常说明源站无法连接，可以在访问日志里查看详情（如果开启了访问日志的话）。此时，请检查：
1. 你有没有在源站中设置源站；
2. 你是否在源站设置中设置了源站的专属域名，导致用户访问专属域名以外的域名时无法匹配到源站；
3. 你填写的源站的协议、域名、端口等信息是否正确；
4. 检查源站是否返回了`502`；
5. 通过 `curl` 或者 `wget` 等工具在边缘节点上直接访问源站URL，检查在边缘节点上是否能正常访问源站；
6. 如果源站设置有防火墙或者限流设置，请关闭或者设置边缘节点为白名单。

## 504 Gateway Timeout 是怎么回事？
出现 `504 Gateway Timeout` 通常说明源站连接超时，可以在访问日志里查看详情（如果开启了访问日志的话）。此时，请检查：
1. 检查源站的协议、域名、端口是否正确；
2. 源站是否返回了`504`；
3. 通过 `curl` 或者 `wget` 等工具在边缘节点上直接访问源站URL，检查在边缘节点上是否能正常访问源站；
4. 如果源站设置有防火墙或者限流设置，请关闭或者设置边缘节点为白名单。

在访问日志详情（访问日志后面图标点开）中"综合信息"页面会给出具体的错误，通常是：
* `dial tcp: xxx.xxx.xxx.xxx .. i/o timeout` - 指的是节点通过TCP连接源站超时；通常是节点和源站的网络连接状况不佳，也有可能是源站设置了一些限流、限速措施，导致边缘节点无法正常连接源站；
* `dial tcp: lookup example.com on xxx.xxx.xxx.xxx` - 指的是节点通过TCP连接域名解析服务超时，请检查节点设置的域名解析服务服务器地址是否正确、是否可以正常连接（`Linux` 上通常可以查看 `/etc/resolv.conf` ）；
* `dial udp: lookup example.com on xxx.xxx.xxx.xxx` - 指的是节点通过UDP连接域名解析服务超时，请检查节点设置的域名解析服务服务器地址是否正确、是否可以正常连接（`Linux` 上通常可以查看 `/etc/resolv.conf` ）；
* `tls handshake timeout` - TLS握手超时

## 使用CDN后报头无法读取？
有些自定义的报头经过CDN之后，源站无法读取，可能的原因是${DocSystemName}会自动将用户自定义的报头名称换为标准的报头，比如用户的请求中含有：
~~~
auth-key: MTIzNDU2
X-WWW-Echo: Helo
~~~
那么，经过CDN之后，源站接收到的报头会变成：
~~~
Auth-Key: MTIzNDU2
X-Www-Echo: Helo
~~~

在HTTP/2中在浏览器端查看的报头可能全部是小写的，但是实际在传输中报头都是首字母大写的。

知道原因后，我们就有了解决方案：
* 方法1：修改源站的程序，从原先不标准的报头名称改为标准的报头名称，比如从 `auth-key` 改为 `Auth-Key`；
* 方法2：在网站设置"HTTP报头" -- "请求报头"中自定义一个新的非标准报头，比如名称为`auth-key`，值为`${header.Auth-Key}`，这样可以强行添加一个非标准报头在请求中，源站接收到的就是非标准的`auth-key`。

## 使用CDN后浏览器无限重定向？
如果使用CDN后，浏览器端显示`Too Many Redirects`等无限重定向的现象，那么常见的可能原因有如下几个：
1. 可能原因1：源站中设置的源站域名和CDN域名一致：如果源站的域名和用户访问CDN的域名是一样的，那么CDN将无法正常读取源站；请务必检查源站设置，防止源站中域名配置和CDN冲突；
2. 可能原因2：源站地址是HTTP，但是在源站设置了自动跳转到HTTPS，所以导致源站一直在HTTP-HTTPS之间不断跳转，这种情况下，有以下几个解决方法：
   1. 取消源站的自动跳转设置（或者根据当前访问域名来判断是否跳转，而不是全部强制跳转）；
   2. 源站地址改为HTTPS的，防止源站自动跳转。

## 出现 ERR_SSL_PROTOCOL_ERROR 错误是怎么回事？
如果你在浏览器上打开网站出现类似于以下的错误：
~~~
此网站无法提供安全连接
xxx.com 发送的响应无效。
ERR_SSL_PROTOCOL_ERROR
~~~ 
通常原因：
1. 可能开启了网站443端口，但是没有上传SSL证书导致，你可以上传证书或者关闭`443`端口来解决此问题；
2. 你没有在对应的网站里绑定当前访问的域名；
3. 可能错误地在HTTP里将端口设置为443，请改为在HTTPS里设置这个端口。

## 开启HTTPS后浏览器提示 ERR_SSL_VERSION_OR_CIPHER_MISMATCH
通常的几个原因：
* 没有上传对应域名的SSL证书导致，请上传证书后再试；
* 绑定的域名没有填写正确，请在"域名"设置里查看域名是否填写正确、是否有同一个域名绑定多个服务的情形。

## 已经上传了证书但是浏览器提示不安全
如果已经在管理系统绑定了域名，且已经上传此域名对应的证书，在浏览器上访问时仍然提示"不安全"类似字样，可能的几个原因：
1. 你访问的是HTTP网址，而不是HTTPS网址，比如 `http://你的域名`，此时请换成HTTPS访问，直接输入 `https://你的域名` 来验证你的HTTPS设置是否成功；如果使用HTTPS访问成功，你只需要在网站设置里设置让HTTP自动跳转到HTTPS即可；
2. 你访问的域名没有在"域名"设置里加入；
3. 你访问的域名证书不正确。

## 源站提示无法找到域名
如果源站提示 `Invalid Hostname` 之类的错误，或者提示找不到对应的网站，或者显示的是别的域名对应网站的内容，原因是你没有设置正确的回源主机名。默认情况下，回源主机名和终端用户访问的域名一致，但如果你的源站不支持用户直接访问的域名的话，可以在"源站" -- "更多设置"中统一修改回源主机名，修改为源站域名；如果你每个源站域名不一样的话，可以点开修改每个源站，然后设置对应的回源主机名；如果源站使用的是特殊的端口，那么你设置的回源主机名中可能也需要添加对应的端口（比如 `example.com:9200`）。

## 499是什么错误？
客户端在发送请求过程中取消请求的时候，会记录一个499，通常可以忽略。

## 如何禁止用户通过节点IP访问网站？
可以在对应集群设置 -- "网站设置"中开启"禁止未绑定域名访问"，并取消"允许使用节点IP访问"选项勾选，然后保存。